<!doctype html>
<html lang="fr">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
          integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

    <title>Orientation Covid-19</title>
</head>
<body>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM"
        crossorigin="anonymous"></script>

<div class="col-md-6 offset-md-3">
    <h1>Décision d'orientation</h1>
    <br>

    <?php

    //affectation des messages dans des constantes
    const Fin1 = "Cette application n'est pas faite pour les personnes de moins de 15 ans. Prenez contact avec votre médecin généraliste au moindre doute. En cas d'urgence, appelez le 15.";
    const Fin3 = "Votre situation peut relever d'un Covid-19. Demandez une téléconsultation ou un médecin généraliste ou une visite à domicile. Appelez le 15 si une gêne respiratoire ou des difficultés importantes pour vous alimenter ou boire apparaissent pendant plus de 24 heures. En attendant et pour casser les chaînes de transmission, nous vous conseillons de vous isoler et de respecter les gestes barrières pour protéger vos proches.";
    const Fin4 = "Votre situation peut relever d'un Covid-19. Demandez une téléconsultation ou un médecin généraliste ou une visite à domicile. Si vous n'arrivez pas à obtenir de consultation, appelez le 15. En attendant et pour casser les chaînes de transmission, nous vous conseillons de vous isoler et de respecter les gestes barrières pour protéger vos proches.";
    const Fin5 = "Appelez le 15.";
    const Fin6 = "Votre situation peut relever d'un Covid-19. Demandez une téléconsultation ou un médecin généraliste ou une visite à domicile (SOS médecins, etc.) En attendant et pour casser les chaînes de transmission, nous vous conseillons de vous isoler et de respecter les gestes barrières pour protéger vos proches.";
    const Fin7 = "Votre situation peut relever d'un Covid-19. Demandez une téléconsultation ou un médecin généraliste. Au moindre doute, appelez le 15. En attendant et pour casser les chaînes de transmission, nous vous conseillons de vous isoler et de respecter les gestes barrières pour protéger vos proches.";
    const Fin8 = "Votre situation ne relève probablement pas du Covid-19. N'hésitez pas à contacter votre médecin en cas de doute. Vous pouvez refaire le test en cas de nouveau symptôme pour réévaluer la situation. Pour toute information concernant le Covid-19, composer le 0 800 ….";
    const Autre = "Pas de quoi s'inquiéter, reposez vous et allez voir votre médecin traitant si les symptomes persistent";


    //Test de validation de la saisie de tous les critères
    if (!isset($_POST['age']) or !isset($_POST['fievre']) or !isset($_POST['imc']) or !isset($_POST['douleurs']) or !isset($_POST['toux']) or !isset($_POST['fatigue']) or !isset($_POST['gene_respi']) or !isset($_POST['diarrhee']) or !isset($_POST['anosmie']) or !isset($_POST['diabete']) or !isset($_POST['difficultes'])) {
        echo("Saisie incomplète ! Merci de renseigner tous les critères.");
    } else {
        //Récupération des données du formulaire et affectation des variables
        $age = $_POST['age'];
        $fievre = $_POST['fievre'];
        $imc = $_POST['imc'];
        $douleurs = $_POST['douleurs'];
        $toux = $_POST['toux'];
        $fatigue = $_POST['fatigue'];
        $gene_respi = $_POST['gene_respi'];
        $diarrhee = $_POST['diarrhee'];
        $anosmie = $_POST['anosmie'];
        $diabete = $_POST['diabete'];
        $difficultes = $_POST['difficultes'];


        //test age
        if ($age == "<15") {
            echo Fin1;
        } else {
            //tests critères majeurs
            if ($difficultes == "oui" or $gene_respi == "oui") {
                echo Fin5;
            } else {
                //tests si fievre et toux
                if (($fievre == "oui" or $fievre == ">=39°" or $fievre == "<35,5°") and $toux == "oui") {
                    //si au moins un facteur pronostique
                    if ($age == ">=65" or $diabete == "oui" or $imc == ">=30 kg/m²" or $gene_respi == "oui") {
                        //si 1 facteur de gravité mineur
                        if ($fatigue == "oui") {
                            echo Fin7;
                        } else if ($fatigue == "non") {
                            echo Fin4;
                        }
                    } else {
                        echo Fin6;
                    }
                } else {
                    //tests Si toux ET NON douleurs ET NON anosmie
                    if ($toux == "oui" and $douleurs == "non" and $anosmie == "non") {
                        //si au moins un facteur pronostique
                        if ($age == ">=65" or $diabete == "oui" or $imc == ">=30 kg/m²" or $gene_respi == "oui") {
                            echo Fin7;
                        } else {
                            echo Fin6;
                        }
                    } else {
                        //test Si NON toux ET NON douleurs ET NON anosmie
                        if ($toux == "non" and $douleurs == "non" and $anosmie == "non") {
                            echo Fin8;
                        } else {
                            echo Autre;
                        }
                    }
                }
            }
        }
    }

    ?>
    <br><br>
	<a href="#" class="btn btn-primary" onclick="history.go(-1);" role="button">Retour</a>
</div>
</body>
</html>
